import asyncio
from py_pli.pylib import VUnits
import config_enum.scan_table_enum as scan_table_enum
import time

async def simple_init():
    await VUnits.instance.hal.nodes["EEFNode"].StartFirmware()
    await VUnits.instance.hal.scan_table.InitializeDevice()
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.Home()
    await scan_table.UseProfile(1)
    print('Initialization scan table done.')

async def init():
    await VUnits.instance.hal.StartupHardware()
    await VUnits.instance.hal.InitializeDevice()
    await VUnits.instance.hal.plateDoor.Home()
    await VUnits.instance.hal.plateDoor.Open()
    await VUnits.instance.hal.filterModuleSlider.Home()
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.Home()
    await scan_table.UseProfile(1)


async def scan_table(seconds):
    scan_table = VUnits.instance.hal.scan_table

    start = time.time()

    while ((time.time() - start) < seconds):
        await scan_table.Move(80, 70)
        await scan_table.Move(20, 40)
        await scan_table.Move(80, 40)
        await scan_table.Move(20, 70)
        await scan_table.Move(80, 70)
        await scan_table.Move(80, 40)
        await scan_table.Move(50, 20)
        await scan_table.Move(20, 40)
        await scan_table.Move(20, 70)

    await scan_table.Move(80, 70)

async def as_init():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.InitializeDevice()
    stepErrors = await as1.Home()
    
    print("Homed!!!!" + str(stepErrors))
